#version 330
#extension GL_EXT_gpu_shader4 : enable
// Icecream worldMod01.fsh by  jpupper

//https://www.shadertoy.com/view/3scBzf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


#define pi 3.14159265359

// COPIAR OBJETOS A LO LARGO DE VARIOS EJES

// utilizando la función mod, podemos repetir objetos en la escena

// VARIABLES GLOBALES

float det = 0.004;
float maxdist = 1000.;

int maxsteps = 1000;

vec3 objcol;

// FUNCION DE ROTACION

mat2 rot(float a) {
    float s=sin(a), c=cos(a);
    return mat2(c,s,-s,c);
}


// FUNCIONES DE DISTANCIA PRIMITIVAS 

float sphere(vec3 p, float rad) 
{
    return length(p) - rad;
}

float box(vec3 p, vec3 c)
{
    p=abs(p)-c;
    return length(max(p,0.))+min(0.,max(p.z,max(p.x,p.y)));
}

float ground(vec3 p, float y) 
{
    p.y += y;
    return abs(p.y);
}


// FUNCION DE ESTIMACION DE DISTANCIA
float mapr(float _value,float _low2,float _high2) {
    float val = _low2 + (_high2 - _low2) * (_value - 0.) / (1.0 - 0.);
    //float val = 0.1;
    return val;
}




float sdCone( vec3 p, vec2 c, float h )
{
  float q = length(p.xz);
  return max(dot(c.xy,vec2(q,p.y)),-h-p.y);
}
float sdSphere( vec3 p, float s )
{
  return length(p)-s;
}
float de(vec3 p) 
{


    float box = 1.;
    vec3 pos = p;
    float pz = abs(fract(sin(p.z*0.33)*1.0-1.));
    
    float cnt = 4.;
    vec3 col1 = vec3(0.9,0.2,0.7);
    vec3 col2 = vec3(0.4,0.5,0.8);
   
    for(float i=0.; i<cnt; i++){
        float index = i/float(cnt);
        float ms = 5.;
       // p.x+= i;
      //    p.z+= sin(index*pi*+time);
        p.x = mod(p.x, ms) - ms/2.;
        p.z = mod(p.z, ms*2.) - ms*2./2.;
        vec3 pbox = p;
        vec3 pcono = p;
        pcono.y -=1.5;
        pcono.x+= sin(pcono.y*10.+iTime)*0.2;
        
        float mof = cos(p.z*4.+index*pi*4.+iTime)*0.04;
        box = min(box,sdCone(pcono,vec2(0.1+mof,0.01+index*0.05+mof),8.1));   
        
        vec3 col11 = vec3(0.7,0.7,0.7);
        vec3 col12 = vec3(0.7,0.7,0.7);
        vec3 col21 = vec3(0.8,0.2,0.8);
        vec3 col22 = vec3(0.8,0.3,0.4);
        
        col1 = mix(col11,col12,index);
        
        col2 = mix(col21,col22,index);
    }
    vec3 pospiso = pos;
   // pospiso.z+=sin(time);
    //pospiso.y+=sin(p.x*10)*0.2+0.5;
    //pospiso.xy = vec2(sin(p.x));
    pospiso.y += cos(pospiso.x*3.+pospiso.z*4.)*.1;    
    pospiso.y += sin(pospiso.z*4.+pospiso.y*4.)*.1;    
    float pla = ground(pospiso, 0.8);
    
    float d = box;
    
    d = min(box,pla);
    // para generar el cuadriculado   
   
    float c = pow(max(max(fract(p.x),fract(p.y)), fract(p.z)),0.5);
    float b = pow(max(fract(p.x),fract(p.z)),5.);

   // length(fract(pos.xz));
  //  if (d==box) objcol=vec3(0.8-pz,sin(length(fract(pos.zz))*1)*0.7,pz);
 
  
   
   
   
   
    if (d==box) objcol=mix(col1,col2,pz);
    if (d==pla) objcol=vec3(0.7,0.7,0.7);



    return d *.7;
}

// FUNCION NORMAL

vec3 normal(vec3 p) 
{   
    vec2 d = vec2(0., det);
    
    return normalize(vec3(de(p + d.yxx), de(p + d.xyx), de(p + d.xxy)) - de(p));
}

// FUNCION SHADOW
// calcula la sombra, generando un efecto de suavizado de los bordes
// a medida que se aleja del objeto

float shadow(vec3 p, vec3 ldir) {
    float td=.001,sh=150.,d=det;
    
    for (int i=0; i<0; i++) {
        p+=ldir*d;
        d=de(p);
        td+=d;
        sh=min(sh,1.*d/td);
        if (sh<.001) break;
    }
    return clamp(sh,0.,0.9);
}


// FUNCION SHADE

vec3 shade(vec3 p, vec3 dir) {

    vec3 col = objcol;
    
    vec3 lightdir = normalize(vec3(sin(iTime)*0.5+0.5, 0.9, 0.9)); 

    vec3 n = normal(p);

    float sh = shadow(p, lightdir);    
    
    float diff = max(0.0, dot(lightdir, n)) * sh; // multiplicamos por sombra;
    
    vec3 refl = reflect(dir, n);
    
    float spec = pow(max(0., dot(lightdir, refl)), 0.01) * sh; // multiplicamos por sombra;
    
    float amb = .1;
    
    return col*(amb*6.0 + diff) + spec * 0.1;
    
}



// FUNCION DE RAYMARCHING

vec3 march(vec3 from, vec3 dir) 
{

    float d, td=0.;
    vec3 p, col;


    for (int i=0; i<maxsteps; i++) 
    {
        p = from + td * dir;

        d = de(p);

        if (d < det || td > maxdist) break;

        td += d;
    }

    if (d < det)
    {
        p -= det * dir;
        col = shade(p, dir);
    } else {
        // si no golpeo con ningun objeto, llevamos la distancia a la máxima
        // que se definió, o sea al fondo de la escena
        // esto sirve para el correcto cálculo de la niebla
        td = maxdist;
    }
    // efecto niebla
    // mix entre el color obtenido y un color de la niebla
    // utilizando para mezclarlos la funcion exp con la variable td
    // que es la distancia en la que quedo el rayo con respecto a la cam
    // el -.01 en la funcion exp altera la distancia de la niebla
    
    vec3 colfondo = vec3(1.-p.y,1.-p.y,1.-p.y);
    
    float f = sin(dir.z*100.+iTime)*0.5+0.5;
    vec3 col1 = vec3(0.8,0.3,0.4);
    vec3 col2 = vec3(0.7,0.7,0.7);
    vec3 colf = mix(col1,col2,f);
  //  colfondo = col1;
    col = mix(colf,col, exp(-.0005*td*td));
    return col;    
}


// MAIN
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
 
    vec2 uv = gl_FragCoord.xy/iResolution.xy - .5; 

    uv.x *= iResolution.x / iResolution.y; 
    
    vec3 from = vec3(0., 0.,2.);
    //from.z-=time*0.1;
    vec3 dir = normalize(vec3(uv, 1.));

    //una forma simple de rotar la cámara
    //es rotando en los mismos ejes tanto from como dir
    from.xz *= rot(iTime*.2);
    
    from.z-=iTime*1.;
    from.y+=sin(iTime*.001);
     from.y+=1.9;
    //dir.xz *= rot(time*.2);
    //dir.xy *= rot(time*.02);
   // dir.z+= sin(time)*0.8;
    vec3 col = march(from, dir);

    gl_FragColor = vec4(col, 1.);
}